/*
 "rkdet" rootkit/intrusion detector
  Andrew Daviel, February 2000
*/


/* #define XOR */  /* cc -DXOR to test xorc */
/* #define TEST */ /* undef to actually disconnect */
/* #define NOFORK */ /* undef to fork */

#ifndef XPAT
#define XPAT 3  /* xor pattern for filenames */
#endif

#ifndef INTV
#define INTV 20   /* interval between interface checks */
#endif
#ifndef MAXI
#define MAXI 15  /* how often to do checksums cf. interface check */
#endif


#include <stdio.h>
#include <syslog.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

#define MAXF 20
#define SIZES 2000
#define SIZEF 1000

int nf ;
char *file[MAXF];
char *sum[MAXF];
char files[SIZEF] ;
char sums[SIZES] ;
char hostname[100] ;
char mailcmd[150] ;

FILE *mail, *log ;


#include "xstrings.h"

extern int checkInterfaces(char *pmmsg, char *dbmsg) ;

void xorc ( char *buf,int c) {
/*
  mungle/unmungle strings 
*/

  char *p;
  for (p = buf; *p ; p++) {
    *p = *p^c ;
  }
}

void addf (char *name,char *md5cmd) {
/*
  add filenames to check to list
*/
  int len , space, len2, space2 ;
  char line[120] ;
  char args[120], myname[120] ;
  FILE *command ;

  strcpy(myname,name) ;
  xorc(myname,XPAT) ;

#ifdef XOR
  printf("added: %s\n",myname) ;
  return ;
#endif

  sprintf(args,md5cmd,myname) ;

  command = popen(args,"r") ;
  if (command) fgets (line, 120, command) ;
  pclose(command) ;

  space = &sums[SIZES] - &sums[0] - strlen(line)  ;
  space2 = &files[SIZEF] - &files[0] - strlen(myname)  ;

  if (nf>=MAXF || space<0 || space2<0) {
    fprintf(stderr,"Insuffucient space\n") ;
    exit(1) ;
  }

  strcpy(sum[nf],line) ;
  strcpy(file[nf],myname) ;


  len = strlen(file[nf]) ; len++ ;
  if (nf<MAXF-1) {
    file[nf+1] = index(file[nf],0) ; file[nf+1]++ ;
    sum[nf+1] = index(sum[nf],0) ; sum[nf+1]++ ;
  }
  nf++ ;
}

void sigh(int sig) {
  long epoch ;
  char * now ;
  epoch = time(0) ;
  now = ctime(&epoch) ;
  syslog(LOG_WARNING,kilmsg) ;
  log = fopen(mylog,"a") ;
  mail = popen(mailcmd, "w");

  if (log) {
    fprintf(log,"\n%s %s\n%s\n\n",mailmsg,hostname,now ) ;
    fprintf(log,"%s\n",kilmsg ) ;
    fclose(log) ;
  }
  if (mail) {
    fprintf(mail,"%s %s\n%s\n\n",mailmsg,hostname,now ) ;
    fprintf(mail,"%s\n",kilmsg ) ;
    pclose(mail) ;
  }
  signal(sig,sigh) ; /* rearm handler */
}

int main(int argc, char **argv) {
  int status=0, pstatus = 0, istatus = 0 ;
  int i=0, j=0 ;
  int arg1  = 0 ; 
  int ifwatch, down ;
  int done1 = 0 ;
  FILE *command ;
  long epoch ;
  char * now ;

  char msg[200] ;
  char line[120] ;
  char args[120] ;
  char discmd[50] ;

#include "xstrings.c"

/* set up pointers */
  sum[0] = sums ;
  file[0] = files ;
  nf = 0 ;

  if (argv[1]) sscanf( argv[1],"%d",&arg1) ;
  ifwatch = arg1 &  1 ;  /* odd numbers watch interface */
  down = arg1 & 2 ;     /* bit 1 set (2,4, etc.) bring down interface */

  if (down != 0) { 
    strcpy(discmd,offcmd) ;
  } else {
    strcpy(discmd,delcmd) ;
  }

#include "xfiles.c"

#ifdef XOR
  printf("delcmd: %s\n",delcmd) ;
  printf("mylog: %s\n",mylog) ;
  printf("md5cmd: %s\n",md5cmd) ;
  printf("offcmd: %s\n",offcmd) ;
  printf("discmd: %s\n",discmd) ;
  printf("ifcmd: %s\n",ifcmd) ;
  printf("mailcmd: %s\n",mailcmd) ;
  printf("netcmd: %s\n",netcmd) ;
  printf("wcmd: %s\n",wcmd) ;
  printf("downmsg: %s\n",downmsg) ;
  printf("mailmsg: %s\n",mailmsg) ;
  printf("md5msg: %s\n",md5msg) ;
  printf("kmsg: %s\n",kmsg) ;
  printf("kilmsg: %s\n",kilmsg) ;
  printf("pmmsg: %s\n",pmmsg) ;
  printf("dbmsg: %s\n",dbmsg) ;
  exit(0) ;
#endif

    

  umask(077);

  gethostname(hostname, 100);

  sprintf(mailcmd,mailfmt,hostname) ;


  if (ifwatch) {
    istatus = checkInterfaces(pmmsg, dbmsg) ;
    if (istatus != 0) {
      fprintf(stderr,"%s WARNING: %s returned %d\n", argv[0], ifcmd, istatus) ;
      sprintf(msg,"%s WARNING: %s returned %d\n", argv[0], ifcmd, istatus) ;
      syslog(LOG_WARNING,msg) ;
      exit(1) ;
    }
  }

#ifndef NOFORK
  signal(SIGINT,SIG_IGN) ;
  signal(SIGTERM,sigh) ;
 
  /* Become a daemon. */
  switch(fork()) {
    case 0: /* child. */
            setsid(); break;
    case -1: /* Failed to become daemon. */
           fprintf(stderr, "%s: cannot fork.\n", argv[0]);
           sprintf(msg, "%s: cannot fork.\n", argv[0]);
           syslog(LOG_ERR,msg) ;
           exit(1);
    default: /* parent. */
           exit(0);
    }
#endif

  while(1) {
    status = 0 ; istatus = 0 ;
    i++ ;
    if (i > MAXI) {
      for (j=0;j<nf;j++) {                /* for each file to check */
        sprintf(args,md5cmd,file[j]) ;
        command = popen(args,"r") ;       /* get md5 checksum */
        if (command) {
          fgets (line, 120, command) ;
          if (strncmp(sum[j], line, 120)) { /* if different */
            pclose(command) ; sleep(2) ; command = popen(args,"r") ;
            if (command) {
              fgets (line, 120, command) ; /* do 2x to make sure */
              if (strncmp(sum[j], line, 120)) status = 1 ;
            }
          }
        }
        pclose(command) ;
      }
      i = 0 ;
    }
    if (ifwatch) {
      istatus = checkInterfaces(NULL,NULL) ;
    }
    if (istatus != pstatus || status != 0) {                /* if things have changed */
      sprintf(msg,kmsg,status,istatus) ;
      syslog(LOG_ALERT,msg) ;
      if (status != 0 || istatus != 0) {
        epoch = time(0) ;
        now = ctime(&epoch) ;
        log = fopen(mylog,"a") ;
        mail = popen(mailcmd, "w");

        if (log) fprintf(log,"\n%s %s\n%s\n\n",mailmsg,hostname,now ) ;
        if (mail) fprintf(mail,"%s %s\n%s\n\n",mailmsg,hostname,now ) ;

        if (istatus != 0) {
          checkInterfaces(pmmsg, dbmsg) ;
        }
        if (status != 0) {
          for (j=0;j<nf;j++) {
            sprintf(args,md5cmd,file[j]) ;
            command = popen(args,"r") ;
            if (command) {
              fgets (line, 120, command) ;
              pclose(command) ;
            }
            if (strncmp(sum[j], line, 120)) {
              sprintf(msg,md5msg,file[j]) ;
              if (log) fprintf(log,"%s\n", msg);
              if (mail) fprintf(mail,"%s\n",  msg);
              strcpy(sum[j], line) ; /* save new value */
            }
          }
        } /* endif status */
            
        command = popen(wcmd,"r") ;
        if (command) {
          while ( fgets (line, 120, command) ) {
            if (log) fprintf(log,"%s", line);
            if (mail) fprintf(mail,"%s", line);
          }
          pclose(command) ;
        }

        command = popen(netcmd,"r") ;
        if (command) {
          while ( fgets (line, 120, command) ) {
            if (log) fprintf(log,"%s", line);
            if (mail) fprintf(mail,"%s", line);
          }
          pclose(command) ;
        }

        if (mail) pclose(mail) ;
        if (log) fclose(log) ;

#ifndef TEST
        system(discmd) ; /* once to kill sniffer */
        system(discmd) ;  /* then again to disconnect */
        syslog(LOG_EMERG,downmsg) ;
	syslog(LOG_WARNING,discmd) ;

#endif
      } /* endif status or istatus true */
    } /* endif things have changed */
    pstatus = istatus ;
    sleep(INTV) ;
  }
  /* Error! (shouldn't happen) */
  return(1);
}

