#!/bin/sh

# panic script to lockdown machine yet allow ssh access from trusted domain

PATH=/sbin:/bin

ME=`hostname`
ALL=0.0.0.0/0
LOCAL=192.168.0.0/16

# flush input chain
ipchains -F input

# localhost
ipchains -A input -i lo -j ACCEPT

# ssh from local net
ipchains -A input -p tcp -s $LOCAL  -d $ME ssh -j ACCEPT

# ssh to local net
ipchains -A input -p tcp -s $ME  -d $LOCAL ssh -j ACCEPT

# allow SMTP to local net
ipchains -A input -p tcp -s $ME -d LOCAL smtp -j ACCEPT

# default policy deny
ipchains -P input DENY

# flush forward
ipchains -F forward
ipchains -P forward DENY

