/*
Determine whether network interfaces are in promiscuous or debug mode

Based on "ifstatus" by David Curry, Purdue University
ftp://coast.cs.purdue.edu/pub/tools/unix/ifstatus

*/

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <stdio.h>
#include <errno.h>

extern FILE *mail, *log ;

int checkInterfaces(char *pmmsg, char *dbmsg) {
  int n, s, mystatus = 0 ;
  char cbuf[1024];
  char msg[20] ;
  struct ifconf ifc;
  struct ifreq ifr, *ifrp;

  if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) fatal("socket");

  ifc.ifc_buf = cbuf;
  ifc.ifc_len = sizeof(cbuf);

  if (ioctl(s, SIOCGIFCONF, (char *) &ifc) < 0) fatal("ioctl: SIOCGIFCONF");

  close(s);
  ifrp = ifc.ifc_req;

  for (n = ifc.ifc_len / sizeof(struct ifreq); n > 0; n--, ifrp++) {
    if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0) fatal("socket");

    strcpy(ifr.ifr_name, ifrp->ifr_name);

    if (ioctl(s, SIOCGIFFLAGS, (char *) &ifr) < 0) fatal("ioctl: SIOCGIFFLAGS");

    if (ifr.ifr_flags & IFF_PROMISC) {
      if (pmmsg) {
        sprintf(msg,pmmsg,ifr.ifr_name) ;
        if (log) fprintf(log,"%s\n", msg);
        if (mail) fprintf(mail,"%s\n",  msg);
      }
      mystatus |= 2 ;
    }

    if (ifr.ifr_flags & IFF_DEBUG) {
      if (dbmsg) {
        sprintf(msg,dbmsg,ifr.ifr_name) ;
        if (log) fprintf(log,"%s\n", msg);
        if (mail) fprintf(mail,"%s\n",  msg);
      }
      mystatus |= 4 ;
    }
    close(s);
  }
  return (mystatus) ;
}

fatal(char *s1) {
  perror(s1);
  exit(1);
}

