<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: lib.php,v 1.15 2001/07/29 19:51:46 scott Exp $
 $Source: /data/cvsroot/www/tunes/modules/lib.php,v $

 All of the main functions for this tool ... someone plz come
   up with a better name that "this tool" ... :-)

*/

// show the header menu
function show_menu_items ($prefix = '') {
  GLOBAL $w_host, $primary_color, $secondary_color;

  if ( $prefix ) {
  print("<table cellpadding=5>" .
        "  <tr align=center> " .
	"    <td bgcolor=\"$secondary_color\"> <a href=\"$prefix/index.php\">Home</a> </td> " .
	"    <td bgcolor=\"$primary_color\"> <a href=\"$prefix/index.php?action=show_albums\">Albums</a> </td> " .
	"    <td bgcolor=\"$secondary_color\"> <a href=\"$prefix/index.php?action=show_artists\">Artists</a> </td> " .
	"    <td bgcolor=\"$primary_color\"> <a href=\"$prefix/playlist.php\"> Playlists </a> </td> " .
	"    <td bgcolor=\"$secondary_color\"> <a href=\"$prefix/search.php\"> Search </a> </td> " .
	"    <td bgcolor=\"white\"> &nbsp; </td> " .
	"    <td bgcolor=\"$primary_color\"> <a href=\"index.php\"> Admin </a> </td> " .
	"  </tr>" .
	"</table>");
  }
  else {
  print("<table cellpadding=5>" .
        "  <tr align=center> " .
        "    <td bgcolor=\"$secondary_color\"> <a href=\"index.php\">Home</a> </td> " .
        "    <td bgcolor=\"$primary_color\"> <a href=\"index.php?action=show_albums\">Albums</a> </td> " .
        "    <td bgcolor=\"$secondary_color\"> <a href=\"index.php?action=show_artists\">Artists</a> </td> " .
        "    <td bgcolor=\"$primary_color\"> <a href=\"playlist.php\"> Playlists </a> </td> " .
        "    <td bgcolor=\"$secondary_color\"> <a href=\"search.php\"> Search </a> </td> " .
        "    <td bgcolor=\"white\"> &nbsp; </td> " .
        "    <td bgcolor=\"$primary_color\"> <a href=\"admin/index.php\"> Admin </a> </td> " .
        "  </tr>" .
        "</table>");
  }
}

// show the style css mojo
function show_style () {
  GLOBAL $font, $primary_font_color, $secondary_font_color, $background_color;

  print("<style type=\"text/css\">\n" .
        "<!--\n" .
        "body {background: $background_color; font-family: $font; font-size: 8pt; }\n" .
        "p    { color: $primary_font_color; font-family: $font; font-size: 8pt; }\n" .
        "a         { color: $primary_font_color; font-family: $font; }\n" .
        "a:visited { color: $secondary_font_color; font-family: $font; }\n" .
        "a:active  { color: $secondary_font_color; font-family: $font; }\n" .
        "td   { color: $primary_font_color; font-family: $font; font-size: 8pt; }\n" .
        "input { color: $primary_font_color; font-family: $font; font-size: 8pt; }\n" .
        "-->\n" .
        "</style>\n");
}

// Get some random information out of the db and show it on the first page
function show_catalog_info () {
  GLOBAL $dbh, $db_name, $primary_color, $secondary_color;

  $query = "SELECT count(*) FROM song";
  $db_result = mysql_db_query($db_name, $query, $dbh);
  $songs = mysql_fetch_row($db_result);

  $query = "SELECT count(*) FROM album";
  $db_result = mysql_db_query($db_name, $query, $dbh);
  $albums = mysql_fetch_row($db_result);

  $query = "SELECT count(*) FROM artist";
  $db_result = mysql_db_query($db_name, $query, $dbh);
  $artists = mysql_fetch_row($db_result);

  $query = "SELECT sum(size) FROM song";
  $db_result = mysql_db_query($db_name, $query, $dbh);
  $size = mysql_fetch_row($db_result);
  $size = ($size[0]/1000000);

  $query = "SELECT sum(time) FROM song";
  $db_result = mysql_db_query($db_name, $query, $dbh);
  $time = mysql_fetch_row($db_result);

  $hours   = floor($time[0]/3600);
  $minutes = floor(($time[0]-$hours*3600-$seconds)/60);
  $seconds = sprintf("%2d", ($time[0]%60) );

  if ( $size > 1000 ) {
    $total_size = sprintf("%.2f", ($size/1000));
    $size_unit = "Gb";
  }
  else {
    $total_size = sprintf("%.2f", $size);
    $size_unit = "Mb";
  }

  print("<p><table cellpadding=5>\n" .
        "  <tr align=center>\n" .
	"    <td bgcolor=\"$primary_color\"> Albums </td> <td bgcolor=\"$secondary_color\"> <b>$albums[0]</b> </td>" .
	"  </tr>\n" .
	"  <tr align=center>\n" .
	"    <td bgcolor=\"$primary_color\"> Artists </td> <td bgcolor=\"$secondary_color\"> <b>$artists[0]</b> </td>" .
	"  </tr>\n" .
	"  <tr align=center>\n" .
	"    <td bgcolor=\"$primary_color\"> Songs </td> <td bgcolor=\"$secondary_color\"> <b>$songs[0]</b> </td>" .
	"  </tr>\n" .
        "  <tr align=center>\n" .
	"    <td bgcolor=\"$primary_color\"> Total Catalog Size </td> <td bgcolor=\"$secondary_color\"> <b>$total_size $size_unit</b> </td>" .
	"  </tr>\n" .
        "  <tr align=center>\n" .
	"    <td bgcolor=\"$primary_color\"> Total Catalog Time </td>\n" .
	"    <td bgcolor=\"$secondary_color\"> <b>$hours hours, $minutes minutes and $seconds seconds</b> </td>" .
	"  </tr>\n" .
	"</table></p>\n");
}


// Return a random set of songs
function get_random_songs( $limit, $type, $value ) {
  GLOBAL $dbh, $db_name;
  
  // the genre mojo, if its -1 use any song
  if ( $type == 'genre' ) {
    if ( $value == '-1' ) {
      $query = "SELECT id FROM song ORDER BY RAND() LIMIT $limit";
    }
    else {
      $query = "SELECT id FROM song WHERE $type='$value' ORDER BY RAND() LIMIT $limit";
    }
  }
  elseif ( $type ) {
    $query = "SELECT id FROM song WHERE $type='$value' ORDER BY RAND() LIMIT $limit";
  }
  else {
    $query = "SELECT id FROM song ORDER BY RAND() LIMIT $limit";
  }

  $db_result = mysql_db_query($db_name, $query, $dbh);

  $songs = array();
  $count = 0;

  while ( $r = mysql_fetch_row($db_result) ) {
    $songs[$count] = $r[0];
    $count++;
  }

  return ($songs);
}

function show_random_play ( ) {
  GLOBAL $w_host;

  print "<form name=\"random\" method=\"post\" action=\"playlist.m3u\">";

  print "<table>\n";
  print("<tr><td align=left> Play Random Selection: </td> " .
        "<td align=left>\n" .
	"  <select name=random>\n" .
	"    <option value=5>5 songs</option>\n" .
	"    <option value=10>10 songs</option>\n" .
	"    <option value=20>20 songs</option>\n" .
	"    <option value=30>30 songs</option>\n" .
	"  </select>");
  print("</td><td>\n");
  print("from genre");
  print("</td><td>");
  show_genre_pulldown( -1, 0 );
  print("</td></tr>");
  print "<tr><td align=left> &nbsp; </td> <td align=left><input type=submit name=\"action\" value=\"Play!\">\n";
  print "</table>\n";
  
  print "</form>\n"; 
}

// Helper functions for album and artist functions
function show_artist_pulldown ($artist) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT id,name FROM artist ORDER BY name";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  print "<table>\n";
  print("<tr>" .
        "<td align=left>\n" .
	"  <select name=artist>\n");

  while ( $r = mysql_fetch_row($db_result) ) {
    // $r[0] = id, $r[1] = name
    if ( $artist == $r[0] ) {
      print("   <option value=$r[0] SELECTED>$r[1]</option>\n");
    }
    else {
      print("   <option value=$r[0]>$r[1]</option>\n");
    }
  }

  print("  </select>");
  print("</td></tr>");
  print("</table>\n");
}


function show_album_pulldown ($album) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT id,name FROM album ORDER BY name";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  print "<table>\n";
  print("<tr>" .
        "<td align=left>\n" .
        "  <select name=album>\n");

  while ( $r = mysql_fetch_row($db_result) ) {
    // $r[0] = id, $r[1] = name
    if ( $album == $r[0] ) {
      print("   <option value=$r[0] SELECTED>$r[1]</option>\n");
    }
    else {
      print("   <option value=$r[0]>$r[1]</option>\n");
    }
  }
  
  print("  </select>");
  print("</td></tr>");
  print("</table>\n");
}

// Set complete=1 if you want the entire genre list
function show_genre_pulldown ($genre, $complete) {
  GLOBAL $dbh, $db_name;

  // find the genres we have in use
  if ( $complete ) {
    $query = "SELECT id FROM genre";
  }
  else {
    $query = "SELECT DISTINCT genre FROM song";
  }

  $db_result = mysql_db_query($db_name, $query, $dbh);

  print "<table>\n";
  print("<tr>" .
        "<td align=left>\n" .
        "  <select name=genre>\n");

  if ( ! $complete ) {
    $genre_info = get_genre_info( -1 );
    if ( $genre == -1 ) { 
      print("   <option value=\"-1\" SELECTED>$genre_info[0] - ($genre_info[1])</option>\n"); 
    }
    else {
      print("   <option value=\"-1\">$genre_info[0] - ($genre_info[1])</option>\n"); 
    }
  }

  while ( $r = mysql_fetch_row($db_result) ) {
    // $r[0] = genre
    $genre_info = get_genre_info($r[0]);

    if ( $genre == $r[0] ) {
      print("   <option value=$r[0] SELECTED>$genre_info[0] - ($genre_info[1])</option>\n");
    }
    else {
      print("   <option value=$r[0]>$genre_info[0] - ($genre_info[1])</option>\n");
    }
  }

  print("  </select>");
  print("</td></tr>");
  print("</table>\n");
}


// Let's change the album and/or artist name
function update_album_name ($album, $new_name) {
  GLOBAL $dbh, $db_name;

  $query = "UPDATE album SET name='$new_name' WHERE id='$album'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}

// Let's change the album and/or artist name
function update_artist_name ($artist, $new_name) {
  GLOBAL $dbh, $db_name;

  $query = "UPDATE artist SET name='$new_name' WHERE id='$artist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}

// Let's just update a bunch of stuff for this specific song
function update_song ($song, $title, $artist, $album, $genre) {
  GLOBAL $dbh, $db_name;

  $query = "UPDATE song SET title='$title', artist='$artist', album='$album', genre='$genre' WHERE id='$song'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}


/*********************************************************/
/* Functions for getting songs given artist, album or id */
/*********************************************************/
function get_songs_from_album ($album) {
  GLOBAL $dbh, $db_name, $w_host, $m_host;

  $query = "SELECT * FROM song WHERE album='$album' ORDER BY track";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  while ( $r = mysql_fetch_object($db_result) ) {
    $songs[$count] = $r->id;
    $count++;
  }

  return $songs;
}

function get_songs_from_artist ($artist) {
  GLOBAL $dbh, $db_name, $w_host, $m_host;

  $query = "SELECT * FROM song WHERE artist='$artist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $songs = array();
  $count = 0;

  while ( $r = mysql_fetch_object($db_result) ) {
    $songs[$count] = $r->id;
    $count++;
  }

  return $songs;
}

function get_song_from_id ($song_id) {
  GLOBAL $dbh, $db_name, $w_host, $m_host;

  $query = "SELECT * FROM song WHERE id='$song_id'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_object($db_result);
  return $r;
}

/*********************************************************/
/* This is the main song display function.  I found tieing it to the playlist functions
     was really handy in getting added functionality at no cost. */
/*********************************************************/
function show_songs ($songs, $playlist) {
  GLOBAL $dbh, $db_name, $w_host, $m_host, $primary_color, $secondary_color;

  // print form mojo here
  print("<form name=\"songs\" method=\"post\" action=\"playlist.php\">");

  print("<table>\n");

  print("<tr bgcolor=\"#999999\" align=\"center\"> " .
        "<td>&nbsp</td>\n <td><b> Song title </td>\n" .
        "<td><b>Artist</b></td>\n " .
        "<td><b> Album </b></td>\n " .
        "<td><b> Time </b></td>\n " . 
        "<td><b> Size </b></td>\n " . 
        "<td><b> Bitrate </b></td>\n" .
        "<td><b> Genre </b></td>\n" .
        "<td></td></tr>\n");

  while ( list($k,$v) = each($songs) ) {
    $r = get_song_from_id($v);
    $id = $r->id;
    $filename = $r->file;
    $album = $r->album;
    $album_name = get_album_name($album);
    $artist = $r->artist;                        
    $artist_name = get_artist_name($artist);   
    $title = $r->title;
    $bitrate = $r->bitrate;
    $size = $r->size;
    $md5 = $r->md5;
    $time = $r->time;
    $genre_info = get_genre_info($r->genre);

    $minutes = floor($time/60);
    $seconds = sprintf("%02d", ($time%60) );

    $megs = sprintf("%.2f", ($size/1000000));

    $song_list .= "&song=$md5";

    print("<tr>" .
          "<td align=center bgcolor=\"#ffffff\"> <input type=\"checkbox\" name=\"song[]\" value=\"$id\"></input>" .
          "<td bgcolor=\"$primary_color\"><a href=\"http://$m_host/?op=play&song=$md5\"> $title </a></td>" .
          "<td align=center bgcolor=\"$secondary_color\"><a href=\"index.php?artist=$artist\"> $artist_name </a> </td>" .
          "<td align=center bgcolor=\"$primary_color\"> <a href=\"index.php?album=$album\"> $album_name </a> </td>" .
          "<td align=center bgcolor=\"$secondary_color\"> $minutes:$seconds </td>" .
          "<td align=\"center\" bgcolor=\"$primary_color\"> $megs Mb </td>" .
          "<td align=\"center\" bgcolor=\"$secondary_color\"> $bitrate </td>" . 
          "<td align=\"center\" bgcolor=\"$primary_color\"> $genre_info[0] </td>" .
          "<td align=\"center\" bgcolor=\"white\"> <a href=\"admin/song.php?song=$id\"> edit </a> </td>"); 

    if ( $playlist ) {
      print("<td align=\"center\" bgcolor=\"$secondary_color\"> <a href=\"playlist.php?action=remove_song&playlist=$playlist&song=$id\"> Remove from this playlist </a></td>"); 
    }

    print("</tr>\n");
  }

  print("<tr align=\"center\"><td colspan=\"1\"> Playlist:</td>" .
        "<td colspan=\"5\"><input name=\"action\" type=\"submit\" value=\"Add to\"> \n");

  if ( $playlist ) {
    print("<input name=\"action\" type=\"submit\" value=\"Delete from\"> \n");
  }

  show_playlist_dropdown($playlist);

  print("<input name=\"action\" type=\"submit\" value=\"View\"> \n");
  print("<input name=\"action\" type=\"submit\" value=\"Edit\"> \n");

  print("</td></tr>\n");
  print("<tr align=\"center\"><td colspan=\"6\"> " .
        "<input name=\"action\" type=\"submit\" value=\"Play Selected Songs\"></td>");

  print("</table>\n");
  print("</form>\n");
}


/*********************************************************
  Get names from id's for albums and artists
*/
function get_artist_name ($artist) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT name FROM artist WHERE id='$artist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_object($db_result);
  return ($r->name);
}

// this will update the song and album counters for the artist
function update_artist_info($artist_id) {
  GLOBAL $dbh, $db_name;

  // get the count of songs
  $query = "SELECT count(id) FROM song WHERE artist='$artist_id'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_row($db_result);
  $artist->songs = $r[0];

  // get the count of albums
  $query = "SELECT count(DISTINCT album) FROM song WHERE artist='$artist_id'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_row($db_result);
  $artist->albums = $r[0];

  // now update the artist table
  $query = "UPDATE artist SET songs='$artist->songs',albums='$artist->albums' WHERE id='$artist_id'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}


function get_artist_info ($artist_id) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT * FROM artist WHERE id='$artist_id'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  return (mysql_fetch_object($db_result));
}

function get_artist_from_album ($album) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT artist FROM song WHERE album='$album' LIMIT 1";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_row($db_result);

  return ($r[0]);
}

function get_album_name ($album) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT name FROM album WHERE id='$album'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_object($db_result);
  return ($r->name);
}

function get_genre_info($genre_id) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT name FROM genre WHERE id='$genre_id'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  // if its -1 then we're doing all songs
  if ( $genre_id < 0 ) {
    $query = "SELECT count(*) FROM song";
  }
  else {
    $query = "SELECT count(*) FROM song WHERE genre='$genre_id'";
  }

  $genre_result = mysql_db_query($db_name, $query, $dbh);

  $genre_count = mysql_fetch_row($genre_result);

  $r = mysql_fetch_row($db_result);
  return ( array($r[0], $genre_count[0]) );
}

function get_songs_path_from_album ($album) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT md5 FROM song WHERE album='$album' ORDER BY track";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $songs = array();
  $count = 0;

  while ( $r = mysql_fetch_object($db_result) ) {
    $songs[$count] = $r->md5; 
    $count++;
  }

  return ($songs);
}

function get_songs_path_from_artist ($artist) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT md5 FROM song WHERE artist='$artist' ORDER BY track";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $songs = array();
  $count = 0;

  while ( $r = mysql_fetch_object($db_result) ) {
    $songs[$count] = $r->md5;
    $count++;
  }

  return ($songs);
}

// Utility function to help move things along
function get_song_info ($song) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT * FROM song WHERE id='$song'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_object($db_result);

  return ($r);
}

function get_song_info_from_path ($path) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT title,album,artist,time FROM song WHERE md5='$path'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_row($db_result);

  return ($r);
}


function get_songs_path_from_playlist($playlist) {     
  GLOBAL $dbh, $db_name;       

  $query = "SELECT song FROM playlist_data WHERE playlist='$playlist'";
  $db_song_result = mysql_db_query($db_name, $query, $dbh);

  $count = 0;

  while ( $song = mysql_fetch_row($db_song_result) ) {
    $songs[$count] = $song[0];
    $count++;
  }

  return (get_song_path_from_id($songs));
}

function show_artists () {
  GLOBAL $dbh, $db_name, $w_host;
  $query = "SELECT id FROM artist ORDER BY name";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  print("<table>\n");
  while ( $r = mysql_fetch_row($db_result) ) {
    $artist = get_artist_info($r[0]);

    if ( $artist->albums == 1 ) {
      $album_string = "$artist->albums album";
    }
    else {
      $album_string = "$artist->albums albums";
    }

    print("<tr><td><a href=\"index.php?artist=$artist->id\"> $artist->name </a></td><td> $artist->songs songs, " .
          " $album_string </td><td> Play: <a href=\"playlist.m3u?artist=$artist->id\">All</a> | " .
	  "<a href=\"playlist.m3u?artist_random=$artist->id\">Random</a> </tr>\n");
  }
  print("</table>\n");
}

function show_albums () {
  GLOBAL $dbh, $db_name, $w_host;

  $query = "SELECT id,name FROM album ORDER BY name";

  $db_result = mysql_db_query($db_name, $query, $dbh);

  print("<table>\n");
  while ( $r = mysql_fetch_object($db_result) ) {
    $album = $r->id;
    $album_name = $r->name;
    print("<tr><td><a href=\"index.php?album=$album\"> $album_name </a></td> " .
          "<td>Play - <a href=\"playlist.pls?album=$album\">pls</a> | " .
	  "<a href=\"playlist.m3u?album=$album\">m3u</a></td></tr>\n");
  }
  print("</table>\n");
}

function show_albums_for_artist ($artist) {
  GLOBAL $dbh, $db_name, $w_host;

  $query = "SELECT DISTINCT album FROM song WHERE artist='$artist' ORDER BY album";

  $db_result = mysql_db_query($db_name, $query, $dbh);

  print("<table>\n");
  while ( $r = mysql_fetch_object($db_result) ) {
    $album = $r->album;
    $album_name = get_album_name($album);
    print("<tr><td><a href=\"index.php?album=$album\"> $album_name </a> - " .
          "Play: <a href=\"playlist.pls?album=$album\">pls</a> | " .
	  "<a href=\"playlist.m3u?album=$album\">m3u</a> </td></tr>\n");
  }
  print("</table>\n");
}

// playlist functions
function show_playlist_menu () {
  print "<p> Playlist: <a href=\"playlist.php?action=new\"> New </a> | ";
  print "<a href=\"playlist.php?action=view\"> View All </a>";
  print "</p>";
}

function show_playlists () {
  GLOBAL $dbh, $db_name;

  $query = "SELECT DISTINCT id,name FROM playlist";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  print "<table align=\"left\" cellpadding=\"5\">\n";

  if ( mysql_num_rows($db_result) ) {
    while ( $r = mysql_fetch_object($db_result) ) {
      $playlist = $r->name;
      $id = $r->id;

      // find out how many songs in this playlist
      $count_query = "SELECT count(*) FROM playlist_data WHERE playlist='$id'";
      $count_result = mysql_db_query($db_name, $count_query, $dbh);
      $count = mysql_fetch_row($count_result);

      print("<tr><td><a href=\"playlist.php?playlist=$id&action=view_list\"> $playlist  - ($count[0] songs) </a></td> " .
            "<td><a href=\"playlist.php?playlist=$id&action=view_list\">View</a></td>" .
	    "<td><a href=\"playlist.php?playlist=$id&action=edit\">Edit</a></td>".
	    "<td><a href=\"playlist.php?playlist=$id&action=delete_playlist\">Delete</a></td>");
      if ( $count[0] ) {
        print("<td>Play: <a href=\"playlist.pls?playlist=$id\">pls</a> | " .
	      "<a href=\"playlist.m3u?playlist=$id\">m3u</a> </td>");
      }

      print("</tr>\n");
    }
  }
  else {
    print "<tr><td><p> You currently have no saved playlists. </p></td></tr>\n";
  }

  print "</table>\n";
}

function get_song_path_from_id ( $song ) {
  GLOBAL $dbh, $db_name;

  $songs = array();
  $count = 0;

  if ( is_array( $song ) ) {
    while ( list($k,$v) = each($song) ) {
      $query = "SELECT md5 FROM song WHERE id='$v'";
      $db_result = mysql_db_query($db_name, $query, $dbh);

      $r = mysql_fetch_row( $db_result );
      $songs[$count] = $r[0];
      $count++;
    }
  }
  else {
    $query = "SELECT md5 FROM song WHERE id='$song'";
    $db_result = mysql_db_query($db_name, $query, $dbh);

    $r = mysql_fetch_row( $db_result );
    $songs[$count] = $r[0];
  }

  return ($songs);
}

function get_playlist_name ( $playlist ) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT name FROM playlist WHERE id='$playlist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $r = mysql_fetch_object($db_result);

  return ($r->name);
}

function get_playlist_songs ( $playlist ) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT song FROM playlist_data WHERE playlist='$playlist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  $songs = array();
  $count = 0;

  while ( $r = mysql_fetch_object($db_result) ) {
    $songs[$count] = $r->song;
    $count++;
  }

  return ($songs);
}

function show_playlist_create () {
  GLOBAL $w_host;

  print "<form name=\"songs\" method=\"post\" action=\"playlist.php\">";

  print "<table>\n";
  print "<tr><td align=left> Playlist name: </td> <td align=left><input type=text name=playlist_name length=20></td></tr>\n";
  print "<tr><td align=left> &nbsp; </td> <td align=left><input type=submit name=\"action\" value=\"Create\"><input type=reset name=\"Reset\">\n";
  print "</table>\n";
  
  print "</form>\n"; 
}

function show_playlist_edit ( $playlist ) {
  GLOBAL $w_host;

  $playlist_name = get_playlist_name($playlist);

  print "<form name=\"songs\" method=\"post\" action=\"playlist.php\">";

  print "<table>\n";
  print "<tr><td align=left> Playlist name: </td> <td align=left><input type=text name=\"new_playlist_name\" value=\"$playlist_name\" length=20></td></tr>\n";
  print "<tr><td align=left> &nbsp; </td> <td align=left><input type=submit name=\"action\" value=\"Update\">\n";
  print "</table>\n";
  
  print "<input type=hidden name=playlist value=\"$playlist\">\n";
  print "</form>\n"; 
}

function show_playlist_dropdown ($playlist) {
  GLOBAL $dbh, $db_name;

  $query = "SELECT * FROM playlist";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  print "<select name=\"playlist\">\n";
  print "<option value=\"0\"> -New Playlist- </option>\n";

  while ( $r = mysql_fetch_object($db_result) ) {
    if ( $playlist == $r->id ) {
      print "<option value=\"$r->id\" SELECTED> $r->name </option>\n";
    }
    else {
      print "<option value=\"$r->id\"> $r->name </option>\n";
    }
  }

  print "</select>\n";
}

// Create a playlist in the database and return its id
function create_playlist ( $playlist_name ) {
  GLOBAL $dbh, $db_name;

  if ( $playlist_name == 'New Playlist' ) {
    $now = date("m/j/y, g:i a");
    $playlist_name = "New Playlist - $now";
  }

  $query = "INSERT INTO playlist (name) VALUES ('$playlist_name')";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  /* kludge alert ... bug where link identifier can't be specified */
  $id = mysql_insert_id();

  return ($id);
}

function update_playlist ( $playlist, $playlist_name ) {
  GLOBAL $dbh, $db_name;

  $query = "UPDATE playlist SET name='$playlist_name' WHERE id='$playlist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}

function delete_playlist ( $playlist ) {
  GLOBAL $dbh, $db_name;

  $query = "DELETE FROM playlist WHERE id='$playlist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);

  // Should also delete any songs in playlist_data associated with this playlist
  $query = "DELETE FROM playlist_data WHERE playlist='$playlist'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}

function add_song_to_playlist ( $song, $playlist ) {
  GLOBAL $dbh, $db_name;

  if ( is_array($song) ) {
    while ( list($k, $v) = each($song) ) {
      $query = "INSERT INTO playlist_data (playlist, song) VALUES ('$playlist', '$v')";
      $db_result = mysql_db_query($db_name, $query, $dbh);
    }
  }
  else {
    $query = "INSERT INTO playlist_data (playlist, song) VALUES ('$playlist', '$song')";
    $db_result = mysql_db_query($db_name, $query, $dbh);
  }
}

function remove_song_from_playlist ($song, $playlist) {
  GLOBAL $dbh, $db_name;

  if ( is_array($song) ) {
    while ( list($k,$v) = each($song) ) {
      $query = "DELETE FROM playlist_data WHERE song='$v' AND playlist='$playlist'";
      $db_result = mysql_db_query($db_name, $query, $dbh);
    }
  }
  else {
    $query = "DELETE FROM playlist_data WHERE song='$song' AND playlist='$playlist'";
    $db_result = mysql_db_query($db_name, $query, $dbh);
  }
}

// Used to show a form with confirm action button on it (for deleting playlists)
function show_confirm_action ($text, $script, $arg) {
  GLOBAL $w_host;

  print("<p> $text </p>");
  print("<form name=\"confirm\" method=\"post\" action=\"http://$w_host/$script?$arg\">");
  print("<p><input type=submit name=confirm value=Yes> <input type=submit name=confirm value=No> </p>\n");
  print("</form>\n");
}

// search functions
function search_by_type ($type, $search) {
  GLOBAL $dbh, $db_name;

  // supported types are album, artist and song
  if ( $type == 'Album' ) {
    $query = "SELECT id FROM album WHERE name LIKE '%$search%'";
  }
  elseif ( $type == 'Artist' ) {
    $query = "SELECT id FROM artist WHERE name LIKE '%$search%'";
  }
  elseif ( $type == 'Song title' ) {
    $query = "SELECT id FROM song WHERE title LIKE '%$search%'";
  }

  $db_result = mysql_db_query($db_name, $query, $dbh);

  $count = 0;
  
  while ( $r = mysql_fetch_row($db_result) ) {
    $search_result[$count] = $r[0]; 
    $count++;
  }

  return ($search_result);
}

// This recursively searches the path for mp3 files of size greater than 0
function update_catalog($sPath, $verbose) {
  GLOBAL $song_count, $added_song_count, $dbh, $db_name;

  $handle=opendir($sPath); 
  while ($file = readdir($handle)) {
    $retVal[count($retVal)] = $file;
  }

  //Clean up and sort 
  closedir($handle); 
  sort($retVal); 

  while (list($key, $val) = each($retVal)) {
    if ($val != "." && $val != "..") {
      $path = str_replace("//","/",$sPath.$val); 

      if (is_dir($sPath.$val)) { 
        update_catalog($sPath.$val."/", $verbose); 
      } 
      else {
        $file_info = stat($sPath.$val);

        // see if this is an mp3 file and if it is greater than 0 bytes
        if ( ereg("\.mp3",$val) && ($file_info[7] > 0) ) {
	  $song_count++;
	  check_mp3($val, $sPath . $val, $verbose);

	  if ( !($song_count%100) ) {
	    echo "Checked $song_count ... <br>\n";
	  }
        }
      }
    } 
  } 
}


// Insert a new song record
function insert_song_into_catalog($file, $path, $md5, $verbose) {
  GLOBAL $dbh, $db_name;

  $id3 = new id3($path, true);

  // see if this artist exists, if so, get the id, otherwise, create
  if ( !($artist_id = select_artist( $id3->artists )) && ($id3->artists != '') ) {
    $artist_id = insert_artist($id3->artists);
  }
  // see if this album exists, if so, get the id, otherwise, create
  if ( !($album_id = select_album( $id3->album )) && ($id3->album != '') ) {
    $album_id = insert_album($id3->album);
  }

  if ( $verbose ) {
    $title = $id3->name;
    $author = $id3->artists;
    $album = $id3->album;
    print("Adding $title by $author (from album $album).<br>\n"); 
  }

  $album = $album_id;
  $artist = $artist_id;
  $title = addslashes($id3->name);
  $layer = $id3->layer;
  $bitrate = $id3->bitrate;
  $rate = $id3->frequency;
  $mode = $id3->mode;
  $size = $id3->filesize;
  $time = $id3->lengths;
  $track = $id3->track;
  $genre = $id3->genreno;

  $fixed_path = addslashes($path);

  if ( !$title && !$artist ) {
    $title = $path;
  }

  $sql = "INSERT INTO song (file, album, artist, title, layer, bitrate, rate, mode, size, md5, time, track, genre) VALUES " .
         "('$fixed_path', '$album_id', '$artist_id', '$title', '$layer', '$bitrate', '$rate', '$mode', " .
	 "'$size', '$md5', '$time', '$track', '$genre')";
  $db_result = mysql_db_query($db_name, $sql, $dbh);
}

function delete_song($song) {
  GLOBAL $dbh, $db_name;

  $query = "DELETE FROM song WHERE id='$song'";
  $db_result = mysql_db_query($db_name, $query, $dbh);
}

// See if a song exists in the current catalog
function check_mp3 ($file, $path, $verbose) {
  GLOBAL $dbh, $db_name, $added_song_count;

  $file_md5 = md5($path);

  $sql = "SELECT md5 FROM song WHERE md5='$file_md5'"; 
  $db_result = mysql_db_query($db_name, $sql, $dbh);

  if ( !mysql_fetch_row($db_result) ) {
    insert_song_into_catalog($file, $path, $file_md5, $verbose);
    $added_song_count++;

    if ( !($added_song_count%100) ) {
      echo "Added $added_song_count ...<br>\n";
    }
  }
}

function select_artist($artist) {
  GLOBAL $dbh, $db_name;

  $artist = addslashes($artist);

  $sql = "SELECT id FROM artist WHERE name='$artist'";
  $db_result = mysql_db_query($db_name, $sql, $dbh);
  
  $r = mysql_fetch_row($db_result); 

  if ( $r[0] ) {
    return ($r[0]);
  }
  else {
    return 0;
  }
}

function insert_artist($artist) {
  GLOBAL $dbh, $db_name;

  $artist = addslashes($artist);

  $sql = "INSERT INTO artist (name) VALUES ('$artist')";
  $db_result = mysql_db_query($db_name, $sql, $dbh);

  return (mysql_insert_id($dbh));
}

function select_album($album) {
  GLOBAL $dbh, $db_name;

  $album = addslashes($album);

  $sql = "SELECT id FROM album WHERE name='$album'";
  $db_result = mysql_db_query($db_name, $sql, $dbh);

  $r = mysql_fetch_row($db_result);

  if ( $r[0] ) {
    return ($r[0]);
  }
  else {
    return 0;
  }
}

function insert_album($album) {
  GLOBAL $dbh, $db_name;

  $album = addslashes($album);

  $sql = "INSERT INTO album (name) VALUES ('$album')";
  $db_result = mysql_db_query($db_name, $sql, $dbh);

  return (mysql_insert_id($dbh));
}

?>
