<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: search.php,v 1.3 2001/05/06 15:11:10 scott Exp $
 $Source: /data/cvsroot/www/tunes/docs/search.php,v $

 Search stuff.  Can do by artist, album and song title.

 Also case-insensitive for now.

*/

require('../modules/config.php');

if ( $search and $type and $action == 'Search' ) {
  $search_results = search_by_type($type, $search);

  if ( !$search_result ) {
    $no_results = "No matches for your search.";
  }
}

?>

<HTML>
<head>
<title> <?php echo $site_title ?> - Search </title>

<?php show_style() ?>

</head>

<BODY bgcolor="#ffffff">

<?php 
  print("<h2> $site_title - Search </h2>"); 
?>

<?php show_menu_items() ?>

<form name="search" method="post" action="search.php">

<table>
  <tr>
    <td>Search:</td>
    <td><input type=text name=search length=20 value="<?php echo $search ?>"></td>
  </tr>
  <tr>
    <td>Search by:</td>
    <td>

<?php
  $searches = array( 'Artist', 'Album', 'Song title' );

  while ( list( $k,$v ) = each($searches) ) {

    if ( $type == $v ) {
      print "<input type=radio name=type value=\"$v\" CHECKED>$v</input>";
    }
    else {
      print "<input type=radio name=type value=\"$v\">$v</input>";
    }

  }
?>

    </td>
  </tr>
  <tr>
    <td> &nbsp; </td>
    <td> <input type=submit name="action" value="Search"> </td>
  </tr>
</table>

</form>

<hr>

<?php
  if ( $search_results ) {
    print("<ol>\n");

    if ( $type == 'Artist' ) {
      while ( list($k,$v) = each($search_results) ) {
        $artist_name = get_artist_name($v);
        print("<li> <a href=\"index.php?artist=$v\"> $artist_name </a> </li>");
      }
    }
    elseif ( $type == 'Album' ) {
      while ( list($k,$v) = each($search_results) ) {
        $album_name = get_album_name($v);
        print("<li> <a href=\"index.php?album=$v\"> $album_name </a> </li>");
      }
    }
    elseif ( $type == 'Song title' ) {
      show_songs($search_results, $playlist);
    }

    print "</ol>\n";

    print "<hr>\n";
  }
  elseif ( $no_results ) {
    print "<p> $no_results </p>\n";

    print "<hr>\n";
  }
?>

</body>
</html>
