<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: playlist.m3u,v 1.1 2001/04/28 22:43:23 scott Exp $
 $Source: /data/cvsroot/www/tunes/docs/playlist.m3u,v $

 Actually play files from albums, artists or just given
  a bunch of id's.

 Special thanx goes out to Mike Payson and Jon Disnard for
   the means to do this.

*/

header("Content-Type: audio/mpegurl;");

require('../modules/config.php');

if ( $album ) {
  $songs = get_songs_path_from_album( $album );
}
elseif ($artist_random) {
  $song_ids = get_random_songs( 1000, 'artist', $artist);
  $songs = get_song_path_from_id($song_ids);
}
elseif ($artist) {
  $songs = get_songs_path_from_artist( $artist );
}
elseif ( $random ) {
  $song_ids = get_random_songs( $random, 'genre', $genre );
  $songs = get_song_path_from_id($song_ids);
}
elseif ( $playlist ) {
  $songs = get_songs_path_from_playlist( $playlist );
}
elseif ( $song ) {
  $songs = get_song_path_from_id($song);
}

$c = count($songs);
echo("[playlist]\n");
echo("numberofentries=$c\n");
$i = 1;
reset($songs);
while(list($key, $value) = each($songs)){
    $info = get_song_info_from_path($value);
    $album = get_album_name($info[1]);
    $artist = get_artist_name($info[2]);
    echo("file$i=http://$m_host/?op=play&song=$value\n");
    echo("title$i=$info[0] - $album - $artist\n");
    echo("time$i=$info[3]\n");
    ++$i;
}
echo("version=2\n");

?>
