<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: playlist.php,v 1.6 2001/07/29 19:51:46 scott Exp $
 $Source: /data/cvsroot/www/tunes/docs/playlist.php,v $

 Playlist mojo for adding, viewing, deleting, etc.

 How's that for documentation?! :-)

*/

require('../modules/config.php');

if ( $action == 'Play Selected Songs' ) {
  $url = '';
  $songs = '';

  if ( is_array($song) ) {
    while ( list($index, $s) = each($song) ) {
      $url .= "song[]=$s&";
    }
  }
  else {
    $url = 'song[]=$song&';
  }
  header("Location: http://$w_host/playlist.pls?$url;");
}
elseif ( $action == 'Update' ) {
  update_playlist( $playlist, $new_playlist_name );
}

?>

<HTML>
<head>
<title> <?php echo $site_title ?> - Playlist Editor </title>

<?php show_style() ?>

</head>

<BODY bgcolor="#ffffff">

<h2> Playlist Manager </h2>

<?php show_menu_items() ?>
<?php show_playlist_menu() ?>

<?php 

  if ( $playlist ) {
    $playlist_name = get_playlist_name($playlist);

    print("<p> Working on $playlist_name playlist - " .
	  "<a href=\"playlist.php?action=edit&playlist=$playlist\">Edit</a> - " .
          "Play -  <a href=\"playlist.pls?playlist=$playlist\">pls</a> | " .
	  "<a href=\"playlist.m3u?playlist=$playlist\">m3u</a>");
  }

  // add to a playlist
  if ( $action == 'Add to' ) {
    // create a new playlist
    if ( $playlist == '0' ) {
      $playlist = create_playlist('New Playlist');
    }

    add_song_to_playlist( $song, $playlist );
    $songs = get_playlist_songs( $playlist );
   
    show_songs($songs, $playlist );
  }

  // View the specified playlist
  elseif ( $action == 'view_list' or $action == 'View' ) { 
    $songs = get_playlist_songs( $playlist );

    if ( $songs ) {
      show_songs($songs, $playlist );
    }
    else {
      print("<p> No songs in this playlist.</p>\n");
    }
  }

  elseif ( $action == 'add_song' ) { 
    add_song_to_playlist( $song, $playlist );

    $playlist_name = get_playlist_name( $playlist );

    print("<h2> Added song to $playlist_name playlist </h2>"); 

    show_playlist_items( $playlist );
  } 

  elseif ( $action == 'remove_song' or $action == 'Delete from' ) {
    remove_song_from_playlist( $song, $playlist );    

    $songs = get_playlist_songs( $playlist );
    show_songs($songs, $playlist);
  }

  elseif ( $action == 'new' ) {
    show_playlist_create();
  }

  elseif ( $action == 'edit' or $action == 'Edit' ) {
    show_playlist_edit( $playlist );
  }

  elseif ( $action == 'Update' ) {
    // we do the update at the very top so it updates titles, etc

    $songs = get_playlist_songs( $playlist );

    if ( $songs ) {
      show_songs($songs, $playlist);
    }
    else {
      print "<p> You have no songs in this playlist yet.</p>\n";
    }
  }

  elseif ( $action == 'Create' ) {
    if ( $playlist_name == '' ) {
      print "<p><b> Please specify a playlist name </b></p>\n";
      show_playlist_create();
    }
    else {
      create_playlist($playlist_name);
      show_playlists();
    }
  }

  elseif ( $action == 'delete_playlist' ) {
    if ( $confirm == 'Yes' ) {
      delete_playlist($playlist);  

      show_playlists();
    }
    elseif ( $confirm == 'No' ) {
      $songs = get_playlist_songs( $playlist );
      show_songs($songs, $playlist);
    }
    else {
      $playlist_name = get_playlist_name($playlist);
      show_confirm_action("Are you sure you want to delete '$playlist_name' playlist?", 
                          "playlist.php",
			  "action=delete_playlist&playlist=$playlist");
    }
  }

  elseif ( $action == 'delete' ) {

  }

  else {
    show_playlists();
  }

?>

</body>
</html>
