<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: index.php,v 1.8 2001/07/29 19:51:46 scott Exp $
 $Source: /data/cvsroot/www/tunes/docs/index.php,v $

 Do most of the dirty work of displaying the mp3 catalog

*/

require('../modules/config.php');

?>

<HTML>
<head>
<title> <?php echo $site_title ?> </title>

<?php show_style() ?>

</head>

<BODY bgcolor="#ffffff">

<?php 
  print("<h2> $site_title </h2>"); 
?>

<?php show_menu_items() ?>

<?php 

  if ( $action == 'show_albums' ) {
    print("<h3> All Albums </h3>"); 
    show_albums();
  }
  elseif ( $action == 'show_artists' ) {
    print("<h3> All Artists </h3>"); 
    show_artists(); 
  }
  elseif ( $album ) {
    $artist = get_artist_from_album($album);
    $artist_name = get_artist_name($artist);
    $album_name = get_album_name($album);

    print("<h3> $artist_name - $album_name </h3>"); 
    print("<p> Play album - <a href=\"playlist.pls?album=$album\">pls</a> | " .
          "<a href=\"playlist.m3u?album=$album\">m3u</a> </p>\n");
    print("<br>\n");

    $songs = get_songs_from_album($album);
    show_songs($songs, $playlist); 
  }
  elseif ( $artist ) {
    $artist_name = get_artist_name($artist);

    print("<h3> Albums by $artist_name </h3>\n");
    print("<p>Play: <a href=\"playlist.m3u?artist=$artist\">All</a> | " .
          "<a href=\"playlist.m3u?artist_random=$artist\">Random</a></p>");

    show_albums_for_artist($artist);
  }
  elseif ( $artist == 0 and $action == 'show_songs' ) {
    print("<h3> Orphaned Songs </h3>"); 

    $songs = get_songs_from_artist(0);
    show_songs($songs, $playlist);
  }
  else {
    print("<h3> Welcome to <a href=\"http://ampache.kveton.com\">Ampache v.$VERSION</a></h3>"); 

    show_catalog_info();

    show_random_play();
  }
?>

</body>
</html>
