<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: song.php,v 1.3 2001/07/29 19:51:46 scott Exp $
 $Source: /data/cvsroot/www/tunes/docs/admin/song.php,v $

 Edit song information.  Can be just DB or file based (update MP3 ID3 tags).

*/

require('../../modules/config.php');

if ( $action == 'Update' ) {
  $info = get_song_info($song); 

  // check which artist
  if ( $new_artist ) {
    $artist_id = insert_artist($new_artist);
  }
  else {
    $artist_id = $artist;
  }

  // check which album
  if ( $new_album ) {
    $album_id = insert_album($new_album);
  }
  else {
    $album_id = $album;
  }

  // update database
  if ( ($type == 'Both') || ($type == 'Database') ) {
    update_song($song, $title, $artist_id, $album_id, $genre);
    update_artist_info($artist_id);

    if ( $artist_id != $current_artist_id ) {
      update_artist_info($current_artist_id);
    }
  }

  // update file?
  if ( ($type == 'Both') || ($type == 'MP3 file') ) {
    $id3 = new id3( $info->file );

    $genre_info   = get_genre_info($genre);

    $id3->artists = get_artist_name($artist_id);
    $id3->albums  = get_album_name($album_id);
    $id3->genre   = $genre_info[0];

    $id3->write();

    update_artist_info($artist_id);

    if ( $artist_id != $current_artist_id ) {
      update_artist_info($current_artist_id);
    }
  }
}

if ( $song ) {
  $info = get_song_info($song);
}

?>

<HTML>
<head>
<title> <?php echo $site_title ?> - Song Editor </title>

<?php show_style() ?>

</head>

<BODY bgcolor="#ffffff">

<?php 
  print("<h2> $site_title - Song Editor </h2>"); 
?>

<?php show_menu_items("..") ?>

<form name="update_song" method="post" action="song.php">

<table width="90%">
  <tr>
    <td>Title:</td>
    <td><input type=text name=title length=50 value="<?php echo $info->title ?>"></td>
  </tr>

  <tr>
    <td>Artist:</td>
    <td>
        <?php show_artist_pulldown($info->artist) ?>
    </td>
    <td>
    or
    </td>
    <td>
        <input type=text name=new_artist length=50 value="">
    </td>
  </tr>

  <tr>
    <td>Album:</td>
    <td>
        <?php show_album_pulldown($info->album) ?>
    </td>
    <td>
    or 
    </td>
    <td>
        <input type=text name=new_album length=50 value="">
    </td>
  </tr>

  <tr>
    <td>Genre:</td>
    <td>
        <?php show_genre_pulldown($info->genre, 1) ?>
    </td>
  </tr>

  <tr>
    <td>Update:</td>
    <td>
      <input type=radio name=type value="MP3 file"> MP3 file </input>
      <input type=radio name=type value="Database"> Database </input>
      <input type=radio name=type value="Both" CHECKED> Both </input>
    </td>
    <td> &nbsp; </td>
  </tr>
  <tr>
    <td> &nbsp; </td>
    <td> <input type=hidden name="song" value="<?php echo $song ?>"> 
         <input type=hidden name="current_artist_id" value="<?php echo $info->artist ?>"> 
         <input type=submit name="action" value="Update"> </td>
  </tr>
</table>

</form>

<hr>

</body>
</html>
