<?php

/*

 Copyright (c) 2000 Kveton.com
 All rights reserved.

 $Id: index.php,v 1.2 2001/07/29 19:51:46 scott Exp $
 $Source: /data/cvsroot/www/tunes/docs/admin/index.php,v $

 Do most of the dirty work of displaying the mp3 catalog

*/

require('../../modules/config.php');

?>

<HTML>
<head>
<title> <?php echo $site_title ?> - Administration Tools </title>

<?php show_style() ?>

</head>

<BODY bgcolor="#ffffff">

<?php 
  print("<h2> $site_title - Administration Tools</h2>"); 
?>

<?php show_menu_items("..") ?>

<h3>Update the Local Catalog</h3>

<p>Enter a <b>local</b> path to your MP3 archive.  Assuming your database and config files are setup
properly this should populate your catalog for you.</p>

<p><b>Note:</b> this operation can take quite some time and may require you to increase your max_execution_time in your php.ini file.  I've increased this to 120 seconds and am able to maintain a 3000+ song catalog with no problems.</p>

<?php 

if ( $action == 'Update Catalog' ) {

  if ( !ereg('\/$', $path) ) {
    $path .= "/";
  }

  // this way people can't run this on the production server ... hehe
  if ( !(preg_match("/ampache.kveton.com/i", $SERVER_NAME)) ) {
    print "<p>\n";
    update_catalog($path, $verbose);
    
    // let's update the song/album info for each artist
    $query = "SELECT id FROM artist";
    $db_result = mysql_db_query($db_name, $query, $dbh);

    while ( $r = mysql_fetch_row($db_result) ) {
      update_artist_info($r[0]);
    }

    print "</p>\n";
  }
  else {
    print "<p><b>This would normally update the catalog but is currently in test mode so my machine doesn't go bonkers.</b></p>";
  }

  print "<p>Added <b>$added_song_count</b> new songs to the catalog.  Searched a total" .
        " of <b>$song_count</b> songs.</p>\n";

  $song_count = 0;
  $added_song_count = 0;
}

?>

<p>

<form name="update_catalog" method="post" action="index.php">
  
<table cellpadding="5">
  <tr>
    <td>Enter path: (example: /data/music/)</td><td><input type="text" name="path" value="" length="30"></td>
  </tr>
  <tr>
    <td>&nbsp;</td><td><input type="checkbox" name="verbose"> Verbose (note: this is <b>very</b> verbose)</td>
  </tr>
  <tr>
    <td>&nbsp;</td><td><input type="submit" name="action" value="Update Catalog"></td>
  </tr>
</table>

</form>
</p>
<br>

<h3> Manage Orphaned Files </h3>

<p>If a file does not have ID3 tags it won't be very useful to Ampache.  Use this tool to view and subsequently edit your orphaned files.  You have the option to edit the database and/or the actual MP3 file.</p>

<p><a href="../index.php?artist=0&action=show_songs">View Orphaned files</a></p>
<br>


<h3> Update Artist/Album Database Information </h3>

<p><a href="artist.php">Update Artist Information</a></p>

<p><a href="album.php">Update Album Information</a></p>

<hr>

</body>
</html>
