/* 
**  footer.c -- Apache layout module
**  $Revision: 1.4 $
*/

#include "mod_layout.h"

LAYOUT_EXPORT(void)layout_footer(request_rec *r, layout_conf *cfg, layout_request *info) {
	int x = 0;
	int status = OK;
	layout_string **current_footer;

	current_footer = (layout_string **) cfg->footer->elts;

	for(x = 0; x < cfg->footer->nelts; x++) {
		if (isOn(cfg->comment)) 
			ap_rprintf(r, "\n\n<!-- Beginning of: %s -->\n\n", current_footer[x]->comment);
#ifdef DEBUG
		printf("Calling Footer %s\n", current_footer[x]->comment);
#endif

		if (current_footer[x]->type > 0){ 
			ap_rputs(current_footer[x]->string, r);
		} else {
			if ((status = call_container(r, current_footer[x]->string, cfg, info, 1)) != OK) { 
				ap_log_rerror(APLOG_MARK, APLOG_NOERRNO | APLOG_ERR, r, "The following error occured while processing the LayoutFooter : %d", status);
			}
		}

		if (isOn(cfg->comment)) 
			ap_rprintf(r, "\n\n<!-- End of: %s -->\n\n", current_footer[x]->comment );
	}
}
