/*
mod_image - An Apache module to perform server side JPEG scaling
Copyright (C) 2001  Nathaniel Woods

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "jversion.h"
#include "jinclude.h"
#include "jpeglib.h"
#include "mod_image.h"

static void fraction_from_double(double dbl, unsigned int *dividend, unsigned int *divisor)
{
	if (dbl < 1)
	{
		*dividend = 1;
		*divisor = (unsigned int) (1/dbl);
	}
	else
	{
		*dividend = (unsigned int) dbl;
		*divisor = 1;
	}
}

void scale_image(const char *destfilename, const char *sourcefilename, double scale)
{
	FILE *destfile = NULL;
	FILE *sourcefile = NULL;
	struct jpeg_compress_struct cinfo;
	struct jpeg_decompress_struct dinfo;
	struct jpeg_error_mgr jerr;
	JSAMPLE *row = NULL;
	int num_scanlines;

	sourcefile = fopen(sourcefilename, "rb");
	if (!sourcefile)
		goto done;
	destfile = fopen(destfilename, "wb+");
	if (!destfile)
		goto done;

	cinfo.err = jpeg_std_error(&jerr);
	dinfo.err = jpeg_std_error(&jerr);
	jpeg_create_compress(&cinfo);
	jpeg_create_decompress(&dinfo);

	cinfo.in_color_space = JCS_RGB;
	jpeg_set_defaults(&cinfo);

	jpeg_stdio_src(&dinfo, sourcefile);
	jpeg_stdio_dest(&cinfo, destfile);
	jpeg_read_header(&dinfo, TRUE);

	fraction_from_double(scale, &dinfo.scale_num, &dinfo.scale_denom);

	jpeg_calc_output_dimensions(&dinfo);
	jpeg_start_decompress(&dinfo);

	cinfo.image_height = dinfo.output_height;
	cinfo.image_width = dinfo.output_width;
	cinfo.num_components = dinfo.output_components;
	cinfo.input_components = dinfo.output_components;

	jpeg_start_compress(&cinfo, TRUE);

	row = (JSAMPLE *) _alloca(dinfo.output_width * dinfo.output_components);

	while (dinfo.output_scanline < dinfo.output_height)
	{
		num_scanlines = jpeg_read_scanlines(&dinfo, &row, 1);
		jpeg_write_scanlines(&cinfo, &row, num_scanlines);
	}

	jpeg_finish_compress(&cinfo);
	jpeg_finish_decompress(&dinfo);
	jpeg_destroy_compress(&cinfo);
	jpeg_destroy_decompress(&dinfo);

done:
	if (sourcefile)
		fclose(sourcefile);
	if (destfile)
		fclose(destfile);
}
