#include <config.h>

#include <sys/types.h>
#include "defines.h"
#include <stdio.h>
#include <pwd.h>

#define	NFIELDS	7

/*
 * sgetpwent - convert a string to a (struct passwd)
 *
 * sgetpwent() parses a string into the parts required for a password
 * structure.  Strict checking is made for the UID and GID fields and
 * presence of the correct number of colons.  Any failing tests result
 * in a NULL pointer being returned.
 *
 * NOTE: This function uses hard-coded string scanning functions for
 *	performance reasons.  I am going to come up with some conditional
 *	compilation glarp to improve on this in the future.
 */

struct passwd *
sgetpwent(const char *buf)
{
	static struct passwd pwent;
	static char pwdbuf[1024];
	register int	i;
	register char	*cp;
	char	*ep;
	char *fields[NFIELDS];

	/*
	 * Copy the string to a static buffer so the pointers into
	 * the password structure remain valid.
	 */

	if (strlen(buf) >= sizeof pwdbuf)
		return 0;  /* fail if too long */
	strcpy(pwdbuf, buf);

	/*
	 * Save a pointer to the start of each colon separated
	 * field.  The fields are converted into NUL terminated strings.
	 */

	for (cp = pwdbuf, i = 0;i < NFIELDS && cp;i++) {
		fields[i] = cp;
		while (*cp && *cp != ':')
			++cp;
	
		if (*cp)
			*cp++ = '\0';
		else
			cp = 0;
	}

	/*
	 * There must be exactly NFIELDS colon separated fields or
	 * the entry is invalid.  Also, the UID and GID must be non-blank.
	 */

	if (i != NFIELDS || *fields[2] == '\0' || *fields[3] == '\0')
		return 0;

	/*
	 * Each of the fields is converted the appropriate data type
	 * and the result assigned to the password structure.  If the
	 * UID or GID does not convert to an integer value, a NULL
	 * pointer is returned.
	 */

	pwent.pw_name = fields[0];
	pwent.pw_passwd = fields[1];
	if (fields[2][0] == '\0' ||
		((pwent.pw_uid = strtol (fields[2], &ep, 10)) == 0 && *ep)) {
		return 0;
	}
	if (fields[3][0] == '\0' ||
		((pwent.pw_gid = strtol (fields[3], &ep, 10)) == 0 && *ep)) {
		return 0;
	}
#ifdef	ATT_AGE
	cp = pwent.pw_passwd;
	while (*cp && *cp != ',')
		++cp;

	if (*cp) {
		*cp++ = '\0';
		pwent.pw_age = cp;
	} else {
		cp = 0;
		pwent.pw_age = "";
	}
#endif
	pwent.pw_gecos = fields[4];
#ifdef	ATT_COMMENT
	pwent.pw_comment = "";
#endif
	pwent.pw_dir = fields[5];
	pwent.pw_shell = fields[6];

	return &pwent;
}
