#ifndef	_H_GSHADOW
#define	_H_GSHADOW

/*
 * Shadow group security file structure
 */

struct	sgrp {
	char	*sg_name;	/* group name */
	char	*sg_passwd;	/* group password */
	char	**sg_adm;	/* group administator list */
	char	**sg_mem;	/* group membership list */
};

/*
 * Shadow group security file functions.
 */

#include <stdio.h>  /* for FILE */

#if __STDC__
struct	sgrp	*getsgent (void);
struct	sgrp	*getsgnam (const char *);
struct	sgrp	*sgetsgent (const char *);
struct	sgrp	*fgetsgent (FILE *);
void	setsgent (void);
void	endsgent (void);
int	putsgent (const struct sgrp *, FILE *);
#else
struct	sgrp	*getsgent ();
struct	sgrp	*getsgnam ();
struct	sgrp	*sgetsgent ();
struct	sgrp	*fgetsgent ();
void	setsgent ();
void	endsgent ();
int	putsgent ();
#endif

#define	GSHADOW	"/etc/gshadow"
#endif /* ifndef _H_GSHADOW */
