#!/bin/bash

echo "create-html.sh for chpasswd 2.0, make by ml0dy"

#Added i18n format choice for translation
#for Ale Feltes Quenhan <afeltes@uca.edu.py>
#Try to obtain LANG from shell variable
#...and little correct by ml0dy

ASK="yes"
if [ ! -z "$LANG" ]; then
	echo "*** I founded the variable LANG set to $LANG"
	if [ -d "html.$LANG" ]; then
		echo "*** I have this language version, so automatic choice to $LANG"
		LAN=$LANG
		ASK="no"
	else
		echo "*** I don't have this language version, so MAKE it (see README file)" 
	fi
fi
echo

if [ "$1" = "-manual" ]; then ASK="yes"; fi
if [ "$1" = "-automatic" ]; then ASK="no"; LAN="us_US"; fi
if [ "$ASK" = "yes" ]; then

echo "Languages: us,es,pl,de" 
echo -n "Enter i18 language for html [ us ] : "
read I18N

if [ "$I18N" = "us" ]; then
        LAN="us_US"
        echo "Your choice: English language"
fi
if [ "$I18N" = "es" ]; then
	LAN="es_ES"
	echo "Your choice: Spanish language"
fi
if [ "$I18N" = "pl" ]; then
        LAN="pl_PL"
        echo "Your choice: Polish language"
fi
if [ "$I18N" = "de" ]; then
        LAN="de_DE"
        echo "Your choice: German language"
fi

if [ -z "$I18N" ]; then
	LAN="us_US"
	echo "Your choice: English language"
fi

if [ ! -d "html.$LAN" ]; then
	echo "*** WARNING ***"
	echo "You chose $LAN but I can't find it in the source directory (see README file)"
	echo "I'll use english HTML's instead."
	LAN=us_US
fi

fi

rm -f html
ln -sf html.$LAN html



echo >html.h
for i in $(ls html | awk -F"." '{ print $1 }'); do
   echo "conwerting... '$i' file"
   echo "#define HTML$i \"" >>html.h
   cat html/$i.html | sed 's/\\/\\\\/g' | sed 's/\"/\\"/g' | sed 's/%/%%/g'  >>html.h
   echo "\"" >>html.h
   echo >>html.h

done;

echo "done."
