/*
 * chpasswd.cgi - CGI script for changing passwords by WWW
 * Copyright (C) 2000, Benedykt Kroplewski <mlody@popnet.pl>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <stdlib.h>
#include <pwd.h>
#include <shadow.h>
#include <fcntl.h>
#include <sys/types.h>
#include <time.h>
#include "libs.h"
#include "salt.h"
#include "html.h"
#include "cgilib.h"
#include "mgets.h"

#define FATALERR "FATAL ERROR,Check your syslogd messages..."
#define DENY_PATH "/etc/www.deny"

#ifdef LOG_AUTHPRIV
# define LOGFACILITY LOG_AUTHPRIV
#else
# define LOGFACILITY LOG_AUTH
#endif
#define LOGS (LOGFACILITY | LOG_INFO)
#define LOGNOTICE (LOGFACILITY | LOG_NOTICE)


static int is_shadow_pwd;
static int change_pass(char *name,char *old_pass, char *new_pass);
static int deny_check(char *name);

int main()
{
int rm,rcp;
char *rhost, *raddr, *ref;
char *unkn,*login,*pass,*npass,*npass2;

   	printf("Content-type: text/html\n\n");
   	fflush(stdout);

	openlog("chpasswd.cgi",LOG_PID,LOGFACILITY);
	raddr = getenv("REMOTE_ADDR"); if(raddr == NULL) raddr = "unknown";
	rhost = getenv("REMOTE_HOST"); if(rhost == NULL) rhost = "unknown";
	ref = getenv("HTTP_REFERER"); if(ref == NULL) ref = "unknown";

	rm = rmethod();

	if(!((rm == 1) || (rm == 2))) 
	{
        	printf("Unknown method\n");
        	syslog(LOGS,"Program called not by HTTP or unknown method");
		exit(1);
	}


	if(rm == 1) /* GET method */ 
	{
		syslog(LOGS,"[%s] - %s - Meth GET, From %s",raddr,rhost,ref); 
		printf(HTMLindex);
		exit(0);
	}

	if(rm == 2) /* POST method */
	{
		syslog(LOGS,"[%s] - %s - Meth POST, From %s",raddr,rhost,ref); 

		if((unkn = POSTentry()) == NULL)   { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - cannot read 1 argument or it's NULL",raddr,rhost); exit(1); }
		if(strcmp(unkn,"login"))           { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - 1 argument haven't name 'login'",raddr,rhost); exit(1); }
		if((login = POSTentry()) == NULL)  { printf(HTMLerror1); fflush(stdout); syslog(LOGS,"[%s] - %s - You didn't write your login, that's stupid...",raddr,rhost); exit(1); }

      		if((unkn = POSTentry()) == NULL)   { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - cannot read 2 argument or it's NULL",raddr,rhost); exit(1); }
      		if(strcmp(unkn,"password"))        { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - 2 argument haven't name 'password'",raddr,rhost); exit(1); }
      		if((pass = POSTentry()) == NULL)   { printf(HTMLerror2); fflush(stdout); syslog(LOGS,"[%s] - %s - You didn't write your current password...",raddr,rhost); exit(1); }


      		if((unkn = POSTentry()) == NULL)   { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - cannot read 3 argument or it's NULL",raddr,rhost); exit(1); }
      		if(strcmp(unkn,"newpassword"))     { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - 3 argument haven't name 'newpassword'",raddr,rhost); exit(1); }
      		if((npass = POSTentry()) == NULL)  { printf(HTMLerror6); fflush(stdout); syslog(LOGS,"[%s] - %s - You didn't write your new password...",raddr,rhost); exit(1); }


      		if((unkn = POSTentry()) == NULL)   { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - cannot read 4 argument or it's NULL",raddr,rhost); exit(1); }
      		if(strcmp(unkn,"newpassword2"))    { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - 4 argument haven't name 'newpassword2'",raddr,rhost); exit(1); }
      		if((npass2 = POSTentry()) == NULL) { printf(HTMLerror8); fflush(stdout); syslog(LOGS,"[%s] - %s - You didn't write your new password (confirm)...",raddr,rhost); exit(1); }

      		if(strcmp(npass,npass2)) { printf(HTMLerror3); fflush(stdout); syslog(LOGS,"[%s] - %s - Your new password and confirmed new password do not match. (USER=%s)",raddr,rhost,login); exit(1); }

/*
 * HERE IS PASSWORD CHANGE PROCEDURE
 */

		rcp = deny_check(login);

		if(rcp == -1) { printf(FATALERR); fflush(stdout); syslog(LOGS,"can't open %s file",DENY_PATH); exit(1); }
		if(rcp == -2) { printf(HTMLerror4); fflush(stdout); syslog(LOGS,"deny username (%s) want change password",login); exit(1); } 

		rcp = change_pass(login, pass, npass);
		if(rcp == 1) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - can't lock password file (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 2) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - can't open password file (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 3) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - can't lock shadow file (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 4) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - can't open shadow file(USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 5) { printf(HTMLerror7); fflush(stdout); syslog(LOGS,"[%s] - %s - Unknown user. (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 6) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - cannot update password entry (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 7) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - error updating shadow file (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 8) { printf(FATALERR); fflush(stdout); syslog(LOGS,"[%s] - %s - error updating password file (USER=%s)",raddr,rhost,login); exit(1); }
		if(rcp == 10) { printf(HTMLerror5); fflush(stdout); syslog(LOGS,"[%s] - %s - Incorrect password...(USER=%s)",raddr,rhost,login); exit(1); }

		if(rcp == 0) { printf(HTMLok); fflush(stdout); syslog(LOGS,"[%s] - %s - USER=%s succefully changed password",raddr,rhost,login); exit(0); }
	
		syslog(LOGS,"[%s] - %s - Something wrong! THIS TEXT CAN't BE DISPLAYed (USER=%s)",raddr,rhost,login);
		printf(FATALERR); fflush(stdout);
		exit(1);
	}

exit(1);
}


/* Return value:
 * 0  - Everething goes OK
 * 1  - can't lock password file
 * 2  - can't open password file
 * 3  - can't lock shadow file
 * 4  - can't open shadow file
 * 5  - unknown user
 * 6  - cannot update password entry
 * 7  - error updating shadow file
 * 8  - error updating password file
 * 10 - Wrong OLD password!
 */
int change_pass(char *name, char *old_pass, char *new_pass)
{
int slt = DES_SALT;
char	*cp = new_pass;
char	*cp1;
char    *newpwd;
int ok;
const struct passwd *pw;
struct  passwd  newpw;
#ifdef HAVE_SHADOW
long    now = time ((long *) 0) / (24L*3600L);
const struct spwd *sp;
struct  spwd    newsp;
#endif


        if (!pw_lock()) 
		return 1;

        if (! pw_open (O_RDWR)) 
		return 2;
	

#ifdef HAVE_SHADOW
        is_shadow_pwd = spw_file_present();
        if (is_shadow_pwd) {
                if (!spw_lock()) 
			return 3;
		
                if (!spw_open(O_RDWR)) {
                        pw_unlock();
                        spw_unlock();
                        return 4;
		}
	}
#endif

	pw = pw_locate(name);
        if (!pw) 
		return 5;
	

#ifdef HAVE_SHADOW
	if (is_shadow_pwd)
		sp = spw_locate(name);
	else
		sp = NULL;	
#endif


#ifdef HAVE_SHADOW
        if (sp)
        {
                cp1 = pw_encrypt(old_pass, sp->sp_pwdp);
                if(strcmp(cp1,sp->sp_pwdp)) { spw_unlock(); pw_unlock(); return 10; }
		if(!strncmp(sp->sp_pwdp, "$1$",3)) slt=MD5_SALT;

        } else
#endif
        {
                cp1 = pw_encrypt(old_pass, pw->pw_passwd);
                if(strcmp(cp1,pw->pw_passwd)) { pw_unlock(); return 10; }
		if(!strncmp(pw->pw_passwd, "$1$",3)) slt=MD5_SALT;
        }


        newpwd = cp;
        cp = pw_encrypt(newpwd, salt(slt));

#ifdef HAVE_SHADOW
	if (sp) {
		newsp = *sp;
		newsp.sp_pwdp = cp;
		newsp.sp_lstchg = now;
	} else
#endif
	{
		newpw = *pw;
		newpw.pw_passwd = cp;
	}
#ifdef HAVE_SHADOW
	if (sp)
		ok = spw_update(&newsp);
	else
#endif
		ok = pw_update(&newpw);

	if (!ok) {
		if (is_shadow_pwd) spw_unlock();
		pw_unlock();
		return 6;
	}

#ifdef HAVE_SHADOW
	if (is_shadow_pwd) {
		if (!spw_close()) {
			pw_unlock();
			return 7;
		}
		spw_unlock();
	}
#endif
	if (!pw_close()) 
		return 8;
	
	pw_unlock();



return 0;
}

FILE *deny;
static int deny_check(char *name)
{
char *line;

	if(( deny = fopen(DENY_PATH,"r")) == NULL) return -1; 
	while(!feof(deny))
	{
		if((line = igetline(deny)) == NULL) break;
		if(!strcmp(line,name)) return -2; 
	}
	fclose(deny);

return 0;
}
 
