#!/bin/bash

echo "Configure script for chpasswd 2.0, make by ml0dy <mlody@popnet.pl>"


if [ ! "$1" = "-manual" ]; then

HTTPD=`(ps ax | grep "httpd" | grep -v "grep httpd") 2>/dev/null`
HTTPD=`(echo $HTTPD | awk '{ print $5 }') 2>/dev/null`

if [ ! "$HTTPD" ]; then
	HTTPD=`(ps ax | grep "apache" | grep -v "grep httpd") 2>/dev/null`
	HTTPD=`(echo $HTTPD | awk '{ print $5 }') 2>/dev/null`
fi

if [ ! "$HTTPD" ]; then
	echo -e "\tERROR: can't find HTTP daemon...it's bad!"
	NORMAL=1
else
	echo -e "\t...finded HTTP daemon ($HTTPD)"
	HTTPDname=`($HTTPD -v 2>&1 | grep "Server version: " | awk '{ print $3 }' | awk -F"/" '{ print $1 }') 2>/dev/null`
	if [ "$HTTPDname" = "Apache" ]; then
		HTTPDver=`($HTTPD -v 2>&1 | grep "Server version: " | awk '{ print $3 }' | awk -F"/" '{ print $2 }') 2>/dev/null`
		echo -e "\t...COOL, Apache HTTP daemon (ver.$HTTPDver)"

                APACHEd=`($HTTPD -V 2>&1 | grep "HTTPD_ROOT" | awk '{ print $2 }' | awk -F\\" '{ print $2 }') 2>/dev/null`
                APACHEconf=`($HTTPD -V 2>&1 | grep "SERVER_CONFIG_FILE" | awk '{ print $2 }' | awk -F\\" '{ print $2 }') 2>/dev/null`


		if [ ! `echo $APACHEconf | grep "^/"` ]; then
			APACHEconf=$APACHEd/$APACHEconf
		fi

		echo -e "\t...configure file: $APACHEconf"

                hGROUP=`(grep -v -E "^#|^ *#" $APACHEconf | grep -E "^Group|^ *Group" | awk '{ print $2 }') 2>/dev/null`
                if [ ! "$hGROUP" ]; then
                       echo -e "\t...can't find Group in config file"
			NORMAL=1
		else
			echo -e "\t...Group = $hGROUP"
                fi


		CGIdir=`(grep -v -E "^#|^ *#" $APACHEconf | grep "cgi-bin" | grep "ScriptAlias" | awk '{ print $3 }' | sed s/\"//g) 2>/dev/null`

		if [ ! "$CGIdir" ]; then

                       APACHEconf=`(grep -v -E "^#|^ *#" $APACHEconf | grep "ResourceConfig" | awk '{ print $2 }') 2>/dev/null`
			if [ ! "$APACHEconf" ]; then
                        APACHEconf=`($HTTPD -V 2>&1 | grep "RESOURCE_CONFIG_FILE" | awk '{ print $2 }' | awk -F\\" '{ print $2 }') 2>/dev/null`
                        fi

                       if [ ! `echo $APACHEconf | grep "^/"` ]; then
                               APACHEconf=$APACHEd/$APACHEconf
                       fi

			echo -e "\t...configure file: $APACHEconf"
	                CGIdir=`(grep -v -E "^#|^ *#" $APACHEconf | grep "cgi-bin" | grep "ScriptAlias" | awk '{ print $3 }' | sed s/\"//g) 2>/dev/null`
			if [ ! "$CGIdir" ]; then
				echo -e "\t...can't find 'ScriptAlias' line in your Apache configuration file"
				NORMAL=1
			else
				CGIdir=`echo "$CGIdir" | sed  's/\/$//g'`
				echo -e "\tCGI-BIN directory: $CGIdir"
			fi
		else
			CGIdir=`echo "$CGIdir" | sed  's/\/$//g'`
			echo -e "\tCGI-BIN directory: $CGIdir"
		fi


	else
		echo -e "\t...it's NO Apache, shame you!"
		NORMAL=1
	fi
fi

else
NORMAL=1
fi

if [ "$NORMAL" ]; then
	echo "USE normal Configuration, Automatic can't recodnize your settings"
CGIdir="/home/httpd/cgi-bin"
hGROUP="nogroup"
	echo -n "Enter CGI-BIN directory [$CGIdir] : "
	read TMP 
	if [ ! -z $TMP ]; then
   		CGIdir=$TMP
	fi
	echo -n "Enter httpd group name [$hGROUP]: "
	read TMP
        if [ ! -z $TMP ]; then
                hGROUP=$TMP
        fi

fi

echo "...correcting Makefile"
	cp Makefile Makefile.org
	grep -v "cp chpasswd " Makefile.org | grep -v "chown " | grep -v "chgrp " | grep -v "chmod " | grep -v "cp www.deny /etc/www.deny" >Makefile
	echo -e "\tcp chpasswd $CGIdir/chpasswd.cgi" >>Makefile
	echo -e "\tchown root $CGIdir/chpasswd.cgi" >>Makefile
	echo -e "\tchgrp $hGROUP $CGIdir/chpasswd.cgi" >>Makefile
	echo -e "\tchmod u+s $CGIdir/chpasswd.cgi" >>Makefile
	echo -e "\tchmod a-rx $CGIdir/chpasswd.cgi" >>Makefile
	echo -e "\tchmod g+rx $CGIdir/chpasswd.cgi" >>Makefile

if [ ! -f /etc/www.deny ]; then
	echo -e "\tcp www.deny /etc/www.deny" >>Makefile
fi


