<?php
##
## PHP/mp3stream play and list configuration
##

set_magic_quotes_runtime(0);
ini_set(magic_quotes_sybase,0);

$_start = microtime();
$_time = time(); // globals timestamp
$_today = mktime(0,0,0);

#################################################
## admin configuration
#################################################

$_pstream['mp3dir'] = '/home/mp3'; // source mp3 directory
$_pstream['logdir'] = dirname(__FILE__).'/../log'; // for write log directoyr
//$_pstream['lame'] = '/usr/local/bin/lame'; // lame application
//$_pstream['oggenc'] = '/usr/local/bin/oggenc'; // oggenc application
$_pstream['playmode'] = 0; // default play mode, mono(1), original mode(0)
$_pstream['download'] = 1; // allow download(1), disable(0)
$_pstream['allowwmp'] = 1; // experimental, allow to Windows-Media-Player playlist(asx)

#################################################
## end of admin configuration
#################################################

$_templates = array
(
  'exp',
  'default',	// default 'templates/default' directory
  'dragonball',
);

$_playmodes = array
(
  'stereo',	// 0, original file streaming mode and bitrate
  'mono',	// 1, force to down mode(if available lame)
);

$_maxlifes = array
(
  array(0,0,'[ Ǳ] ִ  50'),
  array(1,$_today+86400,'[ ] ִ  50'),
  array(2,$_today+86400*2,'[ ] ִ  50'),
  array(3,$_today+86400*7,'[1 ] ִ  50'),
  array(4,$_today+86400*14,'[2 ] ִ  50'),
  array(5,$_today+86400*30,'[1 ] ִ  50'),
  array(6,$_today+86400*60,'[2 ] ִ  50'),
  array(7,$_today+86400*365,'[1 ] ִ  50'),
);

$_userconf = $_COOKIE['_userconf']; // is array()
$_userconf['maxlife'] = $_userconf['maxlife'] ? $_userconf['maxlife'] : 0;
$_userconf['usertmpl'] = $_userconf['usertmpl'] ? $_userconf['usertmpl'] : 0;

$_usertmpl = $_templates["$_userconf[usertmpl]"];
$_maxlife = $_maxlifes["$_userconf[maxlife]"][1];
$_playmode = $_playmodes[($_pstream[playmode]^1)];
$_dircols = 3;

########################################################
## define section
########################################################

## get $_SERVER['_PWD'] and $_SERVER['_URI']
##
realuri(dirname(dirname(__FILE__)));

## configuration debug mode
## 
define('__DEBUG__',1);

## define this program version
##
define('__VERSION__','PHP/MP3 streaming 1.1.3p5');

## define this domain
##
define('__DOMAIN__',str_replace('www.','',strtolower($_SERVER['HTTP_HOST'])));

## define this time
##
define('__TIME__',$_time);

## define today
##
define('__TODAY__',$_today + 86400);

## define cookie maxlife time(_userlist)
##
define('__MAXLIFE__',$_maxlife);

## define __TMPLPATH__
##
define('__TMPLPATH__',$_SERVER['_PWD'].'/templates/'.$_usertmpl);

## set to 'include' directory(template parsing) PATH
##
define('__IPATH__',$_SERVER['_PWD'].'/include/'.$_usertmpl);

## set to max open window width(for view orignal image)
##
define('__MAXW__',780);

## set to max open window height(for view original image)
##
define('__MAXH__',580);

## set to base images,css,... URI _PATH
## 
$_SERVER['_PATH'] = $_SERVER['_ROOT'] = $_SERVER['_URI'].'/templates/'.$_usertmpl;

##
########################################################
## for URL link
##
$TMPL['play'] = $_SERVER['_URI'].'/play.php';		// make play list action
$TMPL['streamer'] = $_SERVER['_URI'].'/stream.php/';	// stream sending action

$TMPL['vimage'] = $_SERVER['_URI'].'/vimage.php';		// view image
$TMPL['vtxt'] = $_SERVER['_URI'].'/vtxt.php';		// view text file
$TMPL['usage'] = $_SERVER['_URI'].'/vtxt.php?t=u';	// view usage txt file
$TMPL['copying'] = $_SERVER['_URI'].'/vtxt.php?t=c';	// view copying txt file
$TMPL['this_about'] = $_SERVER['_URI'].'/vtxt.php?t=a';	// view about txt file

$TMPL['hotmusic'] = $_SERVER['_URI'].'/hotmusic.php';	// hot musics
$TMPL['myplaylist'] = $_SERVER['_URI'].'/playlist.php';	// user play lists
$TMPL['userconfig'] = $_SERVER['_URI'].'/userconfig.php';	// user configurations

$TMPL['act_userconfig'] = $_SERVER['_URI'].'/act/userconfig.php';
$TMPL['act_userlist'] = $_SERVER['_URI'].'/act/userlist.php';
$TMPL['act_download'] = $_SERVER['_URI'].'/act/download/';
##
########################################################

## copyright
##
$TMPL['copyright'] = 'Copyright (c) 1997-'.date('Y',$_time).' linuxchannel.net';

## set to global templates variables, userconfig
##
require_once $_SERVER['_PWD'].'/_conf/tmpl.php'; // default template configuration

## agent player link
##
$_player['win']['link'] = 'http://classic.winamp.com/download/index.jhtml';
$_player['win']['str'] = 'winamp';
$_player['others']['link'] = 'http://xmms.org/';
$_player['others']['str'] = 'XMMS';

?>
