<?php
//
// phpSysInfo - A PHP System Information Script
// http://phpsysinfo.sourceforge.net/
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: index.php,v 1.9 2001/05/30 18:27:37 precision Exp $
//

// default to english, but this is negotiable.
if (!(isset($lng) && file_exists('includes/lang/' . $lng . '.php'))) {
    $lng = 'en';
}
require('includes/lang/' . $lng . '.php');  // get our language include
require('includes/color_scheme.php');        // our default color scheme
require('includes/class.Template.inc.php');  // template library
require('includes/system_functions.php');    // finish defining all of our global functions and variables


// figure out if we got a template passed in the url
if (!(isset($template) && file_exists("templates/$template"))) {
    // default template we should use if we don't get a argument.
    define('TEMPLATE_SET', 'classic');
    $template = 'classic';
} else {
    define('TEMPLATE_SET', $template);
}


// fire up the template engine
$tpl = new Template(dirname(__FILE__) . '/templates/' . TEMPLATE_SET);
$tpl->set_file(array(
    'form' => 'form.tpl'
));


// print out a box of information
function makebox ($title, $content)
{
    $t = new Template(dirname(__FILE__) . '/templates/' . TEMPLATE_SET);

    $t->set_file(array(
        'box'  => 'box.tpl'
    ));

    $t->set_var('title', $title);
    $t->set_var('content', $content);

    return $t->parse('out', 'box');
}  


// let the page begin.
require('includes/system_header.php');

$tpl->set_var('title', $text['title'] . ': ' . sys_chostname() . ' (' . sys_ip_addr() . ')');

require('includes/table_vitals.php');
require('includes/table_network.php');    
require('includes/table_hardware.php');
require('includes/table_memory.php');
require('includes/table_filesystems.php');

// parse our the template
$tpl->pparse('out', 'form');

// finally our print our footer
require('includes/system_footer.php');

?>
